			INCLUDE "code/macro.asm"	;ALIGN macro definition
			INCLUDE "data/charset.asm"	;Charset definition
			INCLUDE "ins2.lst"		;Get addresses of block 2
thebigbuffer		EQU	0C000h			;512 bytes buffer for both screens

exo_mapbasebits		EQU	0C300h		;156 bytes buffer for exomizer, shared with sprite buffer
recording		EQU	0C3A0h		;0 = not recording, 1 = recording, 2=playing
inAA			EQU	0C3A1h		;in (AAh) initial state
check16kRAM		EQU	0C3A2h		;place to check if we have at least 16k
has32k			EQU	0C3A4h		;1 = has at least 32K of RAM, 0 = only 16K
a8rampreslot		EQU	0C3A5h		;Slot configuration for RAM in page 2, same slot duplicated to page 3
a8ramsubslot		EQU	0C3A6h		;Subslot configuration for RAM in page 2
a8ramslot		EQU	0C3A7h		;Slot configuration for RAM in page 2
a8rompreslot		EQU	0C3A8h		;Slot configuration for ROM in page 2, same slot duplicated to page 3
a8romsubslot		EQU	0C3A9h		;Subslot configuration for ROM in page 2
a8romslot		EQU	0C3AAh		;Slot configuration for ROM in page 2
duration_1st		EQU	0C3ABh		;Number of bytes to write in the first third
duration_3rd		EQU	0C3ADh		;Number of bytes to write in the third third
carbuffer		EQU	0C3AFh		;Char Buffer start for first third
colorbuffer		EQU	0C3B1h		;Color Buffer start for first third
carbuffer3		EQU	0C3B3h		;Char Buffer start for third third
colorbuffer3		EQU	0C3B5h		;Color Buffer start for third third
nactive_cars		EQU	0C3B7h		;Number of active cars
humansarrived		EQU	0C3B8h		;Number of humans who have already arrived
minimap_cycle		EQU	0C3B9h		;
fastforward		EQU	0C3BAh		;Indicates if we're fast-forwarding
startpositions_rec	EQU	0C3BBh		;Start positions for replays
end_stage_redirect	EQU	0C3BCh		;end_stage redirection for replay
extra_keys		EQU	0C3BEh		;Store control keys read
snd_state		EQU	0C3BFh		;Sound state
cezb_pos_x		EQU	0C3C0h		;
cezb_pos_y		EQU	0C3C1h
ga_intrax		EQU	0C3C2h		;
ga_intray		EQU	0C3C3h		;
					;Placed below so they can work with 8k
VDPportREAD		EQU	0FFF3h	;+1, usually 99h
VDPportWRITE		EQU	0FFF4h	;+1, usually 99h

pmess_address		EQU	0FFF5h	;Printchars current address
charsrout		EQU	0FFF7h	;Printchars routine
slotvar			EQU	0FFF9h	;slot for ROM page 0
interrupt_redir		EQU	0FFFAh	;interrupt redirector

mapa			EQU	0C400h		;4.5K buffer to uncompress exomized data, and to uncompress map

			ORG	0D600h
camera_left:		defs	18			;map buffer
			defb	2			;car
			defb	54			;mapx
			defb	38			;mapy
			defb	-2			;intrax
			defb	-7			;intray
			defb	6			;posx
			defb	13			;posy
			defw	(thebigbuffer-2)-16*7 	;bufferpos
			defw	23168			;marker attributes
			defw	20480			;marker graphics
			defw	0			;nothing
			defb	1			;ID
			defw	thebigbuffer		;buffer start
			defb	(thebigbuffer/256)+2	;buffer lower limit
			defb	16h			;cam_veloc
			defb	130,190
lap_left_ncol:		defb	131+0*8+4
			defb	"0"-32
			defb	"0"-45
			defb	"0"-32
			defb	"0"-32
lap_left:		defb	"0"-32,127

camera_right:		defs	18			;buffer del mapa
			defb	1			;Coche
			defb	54			;mapx
			defb	38			;mapy
			defb	-6			;intrax
			defb	0			;intray
			defb	6			;posx
			defb	13			;posy
			defw	(thebigbuffer+256)-6	;bufferpos
			defw	22680			;atributos marcador
			defw	16408			;graficos marcador
			defw	0	;defw	message_lap_right	;mensaje de numero de vuelta
			defb	2			;ID
			defw	thebigbuffer+272	;comienzo del buffer
			defb	(thebigbuffer/256)+3	;limite de abajo del buffer
			defb	06h			;cam_veloc
			defb	128,190
lap_right_ncol:		defb	131+0*8+4
			defb	"0"-32
			defb	"0"-45
			defb	"0"-32
			defb	"0"-32
lap_right:		defb	"0"-32,127
						;Coche 1
car1:			defb	208			;color	Magenta
			defb	0			;mapx
			defb	0			;mapy
			defb	0			;intrax
			defb	0			;intray
			defb	0			;subx
			defb	0			;suby
			defb	0			;camera
			defb	0			;frame
			defw	0			;graph
			defb	4			;speed
			defb	0			;subspeed
			defb	0			;state
			defw	0			;control
			defb	0			;subgiro
			defb	0			;minimapx
			defb	0			;minimapy
			defb	0			;nextcheck
			defb	0			;laps
			defb	0			;collision_duration
			defb	0			;collision_direction
			defb	0			;mappoints
			defb	0			;dir_x
			defb	0			;dir_y
			defb	0			;iarand1
			defb	0			;iarand2
			defb	0			;iarand3
			defb	160			;accelrate
			defb	0			;timestamp checkpoint
			defb	0			;timestamp lap
			defb	0,0			;timestamp
			defb	0,0			;lap start
			defb	0,0			;best lap
			defb	0			;relpos
			defb	0			;control option
			defb	0			;points
			defb	208			;master color -> magenta
			defb	0			;novice
			defb	0			;last_control
			defw	0			;control backup
			defb	217			;double color
			defb	144			;secondary color
			defb	0			;tyres
			defb	0			;buffer start
			defb	0			;buffer num
			defb	153			;colormarker
			defb	153			;colormarker master

						;Coche 2
car2:			defb	64			;color	Azul
			defb	0			;mapx
			defb	0			;mapy
			defb	0			;intrax
			defb	0			;intray
			defb	0			;subx
			defb	0			;suby
			defb	1			;camera
			defb	0			;frame
			defw	0			;graph
			defb	0			;speed
			defb	0			;subspeed
			defb	0			;state
			defw	0			;control
			defb	0			;subgiro
			defb	0			;minimapx
			defb	0			;minimapy
			defb	0			;nextcheck
			defb	0			;laps
			defb	0			;collision_duration
			defb	0			;collision_direction
			defb	0			;mappoints
			defb	0			;dir_x
			defb	0			;dir_y
			defb	112			;iarand1
			defb	96			;iarand2
			defb	16			;iarand3
			defb	160			;accelrate
			defb	0			;timestamp checkpoint
			defb	0			;timestamp lap
			defb	0,0			;timestamp
			defb	0,0			;lap start
			defb	0,0			;best lap
			defb	0			;relpos
			defb	7			;control option
			defb	0			;points
			defb	64			;master color = azul
			defb	0			;novice
			defb	0			;last_control
			defw	0			;control backup
			defb	69			;double color
			defb	80			;secondary color
			defb	0			;tyres
			defb	0			;buffer start
			defb	0			;buffer num
			defb	169			;colormarker
			defb	169			;colormarker master

						;Coche 3
car3:			defb	112			;color	Cyan (NEGRO=67)
			defb	0			;mapx
			defb	0			;mapy
			defb	0			;intrax
			defb	0			;intray
			defb	0			;subx
			defb	0			;suby
			defb	2			;camera
			defb	0			;frame
			defw	0			;graph
			defb	0			;speed
			defb	0			;subspeed
			defb    0			;state
			defw	0			;control
			defb	0			;subgiro
			defb	0			;minimapx
			defb	0			;minimapy
			defb	0			;nextcheck
			defb	0			;laps
			defb	0			;collision_duration
			defb	0			;collision_direction
			defb	0			;mappoints
			defb	0			;dir_x
			defb	0			;dir_y
			defb	96			;iarand1
			defb	80			;iarand2
			defb	64			;iarand3
			defb	160			;accelrate
			defb	0			;timestamp checkpoint
			defb	0			;timestamp lap
			defb	0,0			;timestamp
			defb	0,0			;lap start
			defb	0,0			;best lap
			defb	0			;relpos
			defb	6			;control option
			defb	0			;points
			defb	112			;master color = cyan
			defb	0			;novice
			defb	0			;last_control
			defw	0			;control backup
			defb	126			;double color
			defb	224			;secondary color
			defb	0			;tyres
			defb	0			;buffer start
			defb	0			;buffer num
			defb	185			;colormarker
			defb	185			;colormarker master
			
						;Coche 4
car4:			defb	160			;color	Amarillo 
			defb	0			;mapx
			defb	0			;mapy
			defb	0			;intrax
			defb	0			;intray
			defb	0			;subx
			defb	0			;suby
			defb	3			;camera
			defb	0			;frame
			defw	0			;graph
			defb	14			;speed
			defb	0			;subspeed
			defb	0			;state
			defw	0			;control
			defb	0			;subgiro
			defb	0			;minimapx
			defb	0			;minimapy
			defb	0			;nextcheck
			defb	0			;laps
			defb	0			;collision_duration
			defb	0			;collision_direction
			defb	0			;mappoints
			defb	0			;dir_x
			defb	0			;dir_y
			defb	128			;iarand1
			defb	128			;iarand2
			defb	0			;iarand3
			defb	160			;accelrate
			defb	0			;timestamp checkpoint
			defb	0			;timestamp lap
			defb	0,0			;timestamp
			defb	0,0			;lap start
			defb	0,0			;best lap
			defb	0			;relpos
			defb	8			;control option
			defb	0			;points
			defb	160			;master color = amarillo
			defb	0			;novice
			defb	0			;last_control
			defw	0			;control backup
			defb	171			;double color
			defb	176			;secondary color
			defb	0			;tyres
			defb	0			;buffer start
			defb	0			;buffer num
			defb	201			;colormarker
			defb	201			;colormarker master
end_cars:

shadowchar1:		defb	224	;Start of next shadow chars for first third
shadowchar2:		defb	192	;Start of next shadow chars for second third

current_stage_laps:	defb	2
current_sound:		defb 	2
currentmap:		defb	0
keysredefined:		defb	0
								;Outport, and bit, addition
keys1:			defb	8,128,128,8,16,240,8,32,224,8,64,192	;cursores
keys2:			defb	4,32,224,4,16,240,4,64,192,2,64,192	;poqa
keys3:			defb	3,8,248,5,1,255,3,4,252,3,2,254		;fsed
keys4:			defb	5,2,254,5,64,192,3,8,248,3,16,240	;tyfg
mode:			defb	3	;Bit 1 = brujula , bit 0 = novice checkpoints

championship:		defb	0	;0=easy, 1=hard, 2=complete, 3=personal

tableadvance:		defb	0
tablepointer:		defb	tablepoints%256
tablepoints:		defb	5,3,1,0	;Points according to position
tablepointsbl:		defb	1	;Best lap points

lastcamchange:		defw	0
lastsndchange:		defw	0

mapas:			defw	mapa01		;Direccin del mapa comprimido
			defb	0		;Quien ha conseguido el record (7-4 -> humano=1, cpu=0, 3-0 YCBM ) en junior
			defb	0		;Quien ha conseguido el record (7-4 -> humano=1, cpu=0, 3-0 YCBM ) en karts
			defb	0		;Quien ha conseguido el record (7-4 -> humano=1, cpu=0, 3-0 YCBM ) en gp2
			defb	0		;Quien ha conseguido el record (7-4 -> humano=1, cpu=0, 3-0 YCBM ) en f1
			defb	23		;Record junior, parte alta (7-4 -> humano=1, cpu=0, 3-0 YCBM )
			defb	111		;Record junior, parte baja
			defb	23		;Record karts, parte alta
			defb	111		;Record karts, parte baja
			defb	23		;Record gp2, parte alta
			defb	111		;Record gp2, parte baja
			defb	23		;Record f1, parte alta
			defb	111		;Record f1, parte baja
prefdir:		defb	0
changemarker:		defb	0
			defw	mapa02
			defb	0
			defb	0
			defb	0
			defb	0
			defb	23
			defb	111
			defb	23
			defb	111
			defb	23
			defb	111
			defb	23
			defb	111
volume_flag:		defb	0
ticks_period:		defb	0			;Tick period
			defw	mapa03
			defb	0
			defb	0
			defb	0
			defb	0
			defb	23
			defb	111
			defb	23
			defb	111
			defb	23
			defb	111
			defb	23
			defb	111
positionwin:		defb	0
other:			defb	1
			defw	mapa04
			defb	0
			defb	0
			defb	0
			defb	0
			defb	23
			defb	111
			defb	23
			defb	111
			defb	23
			defb	111
			defb	23
			defb	111
			defw	0		;Dummy
			defw	mapa05
			defb	0
			defb	0
			defb	0
			defb	0
			defb	23
			defb	111
			defb	23
			defb	111
			defb	23
			defb	111
			defb	23
			defb	111
bestlap:		defw	0	;New Best lap
			defw	mapa06
			defb	0
			defb	0
			defb	0
			defb	0
			defb	23
			defb	111
			defb	23
			defb	111
			defb	23
			defb	111
			defb	23
			defb	111
main_ticks:		defw	0			;Main Clock All Ticks
			defw	mapa07
			defb	0
			defb	0
			defb	0
			defb	0
			defb	23
			defb	111
			defb	23
			defb	111
			defb	23
			defb	111
			defb	23
			defb	111
humans:			defb	0
cpus:			defb	0
			defw	mapa08
			defb	0
			defb	0
			defb	0
			defb	0
			defb	23
			defb	111
			defb	23
			defb	111
			defb	23
			defb	111
			defb	23
			defb	111

;WYZPLAYER:
INTERR:         	defb	0               ;INTERRUPTORES 1=ON 0=OFF
                                        	;BIT 0=CARGA CANCION ON/OFF
                                        	;BIT 1=PLAYER ON/OFF
                                        	;BIT 2=SONIDOS ON/OFF
                                        	;BIT 3=EFECTOS ON/OFF

;MUSICA **** EL ORDEN DE LAS VARIABLES ES FIJO ******

SONG:           DB     00               ;DBN DE CANCION
TEMPO:          DB     00               ;DB TEMPO
TTEMPO:         DB     00               ;DB CONTADOR TEMPO
PUNTERO_A:      DW     00               ;DW PUNTERO DEL CANAL A
PUNTERO_B:      DW     00               ;DW PUNTERO DEL CANAL B
PUNTERO_C:      DW     00               ;DW PUNTERO DEL CANAL C

CANAL_A:        DW     BUFFER_DEC       ;DW DIRECION DE INICIO DE LA MUSICA A
CANAL_B:        DW     00               ;DW DIRECION DE INICIO DE LA MUSICA B
CANAL_C:        DW     00               ;DW DIRECION DE INICIO DE LA MUSICA C

PUNTERO_P_A:    DW     00               ;DW PUNTERO PAUTA CANAL A
PUNTERO_P_B:    DW     00               ;DW PUNTERO PAUTA CANAL B
PUNTERO_P_C:    DW     00               ;DW PUNTERO PAUTA CANAL C

PUNTERO_P_A0:   DW     00               ;DW INI PUNTERO PAUTA CANAL A
PUNTERO_P_B0:   DW     00               ;DW INI PUNTERO PAUTA CANAL B
PUNTERO_P_C0:   DW     00               ;DW INI PUNTERO PAUTA CANAL C

;CANAL DE EFECTOS - ENMASCARA OTRO CANAL

PUNTERO_P:      DW	00           	;DW PUNTERO DEL CANAL EFECTOS
CANAL_P:        DW     	00           	;DW DIRECION DE INICIO DE LOS EFECTOS

PSG_REG:        DB      00,00,00,00,00,00,00,10111000B,00,00,00,00,00,00,00    ;DB [15] BUFFER DE REGISTROS DEL PSG
PSG_REG_SEC:    DB      00,00,00,00,00,00,00,10111000B,00,00,00,00,00,00,00    ;DB [15] BUFFER SECUNDARIO DE REGISTROS DEL PSG
;EFECTOS DE SONIDO

N_SONIDO:       DB      0               ;DB : NUMERO DE SONIDO
PUNTERO_SONIDO: DW      0               ;DW : PUNTERO DEL SONIDO QUE SE REPRODUCE

;EFECTOS

PUNTERO_EFECTO: DW      0               ;DW : PUNTERO DEL SONIDO QUE SE REPRODUCE

current_rec_byte:	defb  	1	;Initial value=1=bit marker
current_rec_addr:	defw	32768+end_cars-car1	;Initial value=32768
max_rec_addr:		defw	0	;Maximum position reached
;keepstack:		defw	0
;lastbank:		defb	0	;Last memory bank used

msxHZ:			defb	5
int_ticks:		defb	0	;Interrupt tick counter
cc_checkit:		bit	0,(hl)		;Self-modifying part in Spectrum, moved here
			ret			;Go back to the code

;NON-FIXED MESSAGES AFTER THE VARIABLES
marker_message:		defb	128
message_pos1st:		defb	140		;fixed!
message_col1st:		defb	0
			defb	0,0,0,0,0,0
			defb	128
message_pos2nd:		defb	146
message_col2nd:		defb	0
			defb	0,0,0,0,0,0
			defb	128
message_pos3rd:		defb	152
message_col3rd:		defb	0
			defb	0,0,0,0,0,0
			defb	128
message_pos4th:		defb	158
message_col4th:		defb	0
			defb	0,0,0,0,0,0,128
message_black1:		defb	164
			defb	131,6,17,128
message_black2:		defb	170
			defb	131,6,17,128
message_black3:		defb	176
			defb	131,6,17
			defb	127
mes_mt_position:	defb	128
			defb	0
mes_mt_color:		defb	0
mes_mt_m10:		defb	CHR_PLUS
mes_mt_m1:		defb	0
mes_mt_s10:		defb	0
mes_mt_s1:		defb	0,CHR_POINT
mes_mt_d:		defb	0
			defb	127
mes_points_col:		defb	128
mes_points:		defb	0
mes_extrapoints:	defb	CHR_SPACE
			defb	CHR_SPACE
			defb	127

mes_mark_lapch:		defb	CHR_L
mes_ml_lap:		defb	0
			defb	CHR_MINUS	;quitar?
			defb	CHR_C
			defb	CHR_H
				;mes_ml_ch10:	defb	0
mes_ml_ch1:		defb	0

mfirst_all:		defb	128,147,131,4,225,CHR_R,CHR_A,CHR_C,CHR_E,128,164,131,6,225
mfirst_nlaps:		defb	CHR_0,CHR_SPACE,CHR_L,CHR_A,CHR_P,CHR_S
			defb	127
mfirst_play:		defb	128,152,131,6,225
mfirst_nrace:		defb	CHR_0,CHR_SPACE,CHR_O,CHR_F,CHR_SPACE
mfirst_total:		defb	CHR_0
			defb	127
mfirst_replay:		defb	128,152,131+0*16+6,CHR_R,CHR_E,CHR_P,CHR_L,CHR_A,CHR_Y
			defb	127

tr_trackres:		defb	130,38
tr_col1:		defb	131
tr_pos1:		defb	CHR_1,CHR_MINUS
tr_points1:		defb	CHR_0,CHR_0
tr_col2:		defb	131
tr_pos2:		defb	CHR_1,CHR_MINUS
tr_points2:		defb	CHR_0,CHR_0
tr_col3:		defb	131
tr_pos3:		defb	CHR_1,CHR_MINUS
tr_points3:		defb	CHR_0,CHR_0
tr_col4:		defb	131
tr_pos4:		defb	CHR_1,CHR_MINUS
tr_points4:		defb	CHR_0,CHR_0
			defb	127

mmenu_keys1:		defb	CHR_K,CHR_E,CHR_Y,CHR_S,CHR_COLON						;0
mmenu_keys1_def:	defb	CHR_CURRIGHT,CHR_CURLEFT,CHR_CURUP,CHR_CURDOWN
			defb	CHR_SPACE,127
mmenu_keys2:		defb	CHR_K,CHR_E,CHR_Y,CHR_S,CHR_COLON						;1
mmenu_keys2_def:	defb	CHR_P,CHR_O,CHR_Q,CHR_A
			defb	CHR_SPACE,127
mmenu_keys3:		defb	CHR_K,CHR_E,CHR_Y,CHR_S,CHR_COLON						;2
mmenu_keys3_def:	defb	CHR_F,CHR_S,CHR_E,CHR_D
			defb	CHR_SPACE,127
mmenu_joy1:		defb	CHR_J,CHR_O,CHR_Y,CHR_S,CHR_T,CHR_I,CHR_C,CHR_K,CHR_SPACE,CHR_1,127		;3
mmenu_joy2:		defb	CHR_J,CHR_O,CHR_Y,CHR_S,CHR_T,CHR_I,CHR_C,CHR_K,CHR_SPACE,CHR_2,127		;4
mmenu_kempston:		defb	CHR_K,CHR_E,CHR_M,CHR_P,CHR_S,CHR_T,CHR_O,CHR_N,CHR_SPACE,CHR_SPACE,127		;5 no! ->remove
mmenu_cpu1:		defb	CHR_C,CHR_P,CHR_U,CHR_SPACE,CHR_E,CHR_A,CHR_S,CHR_Y,CHR_SPACE,CHR_SPACE,127	;6
mmenu_cpu2:		defb	CHR_C,CHR_P,CHR_U,CHR_SPACE,CHR_N,CHR_O,CHR_R,CHR_M,CHR_A,CHR_L,127		;7
mmenu_cpu3:		defb	CHR_C,CHR_P,CHR_U,CHR_SPACE,CHR_H,CHR_A,CHR_R,CHR_D,CHR_SPACE,CHR_SPACE,127	;8
mmenu_nobody:		defb	CHR_D,CHR_O,CHR_NAPOST,CHR_T,CHR_SPACE,CHR_R,CHR_A,CHR_C,CHR_E,CHR_SPACE,127	;9

mmenu_extrakeys:	defb	128,125,131,2,225
mmenu_keypause:		defb	CHR_T
mmenu_keysound:		defb	CHR_Y
mmenu_cam1shadow:	defb	CHR_F
mmenu_cam2shadow:	defb	CHR_G
			defb	129,65,131,2,225
mmenu_keycam1:		defb	CHR_F
mmenu_keycam2:		defb	CHR_G
			defb	127
snd_speed:		defb	0
championship_personal:
person_maps:		defb	1
			defb	3,2,1,0													;Points for positions
			defb	2													;Points for best lap

			defb	1
			defb	0
			defb	0
			defb	0
			defb	0
			defb	0
			defb	0
			defb	0
			
			defb	0
			defb	0
			defb	0
			defb	0
			defb	0
			defb	0
			defb	0
			defb	0

			defb	0	;MARKER 0, keep it!

mes_attrblock:		defb	128		;Third
mes_attrblockpos:	defb	128		;Position
			defb	131,16
mes_attrblockcol:	defb	113		;Color
			defb	127

message_clock:		defb	128,136
message_cl_m10:		defb	CHR_0
message_cl_m1:		defb	CHR_0_
message_cl_s10:		defb	CHR_0
message_cl_s1:		defb	CHR_0,127

mpers_param:		defb	129,1
mpers_laps0:		defb	CHR_2
mpers_laps1:		defb	CHR_2
mpers_laps2:		defb	CHR_2
mpers_laps3:		defb	CHR_2
mpers_laps4:		defb	CHR_2
mpers_laps5:		defb	CHR_2
mpers_laps6:		defb	CHR_2
mpers_laps7:		defb	CHR_2
mpers_points1:		defb	CHR_5
mpers_points2:		defb	CHR_3
mpers_points3:		defb	CHR_1

			defb	130,51
mpers_points4:		defb	CHR_0
mpers_pointsf:		defb	CHR_1
			defb	127

endg_n1:		defb	0
			defb	0*32+16
endg_n2:		defb	0
			defb	1*32+10
endg_n3:		defb	0
			defb	2*32+22
rainbow_rompoint:	defw	32768
rainbow_data:		defb	0
			defb	0
			defb	0
			defb	0
			defb	0
			defb	0
			defb	0
			defb	0
rainbow_on:		defb	0
aborted:		defb	0
p3_points1:		defb	0
p3_points2:		defb	0

speeds_base:		defb	18	;Junior
			defb	0
			defb	-18
			defb	-35
			defb	-42
speeds:			defb	-46
			defb	-42
			defb	-35
			defb	-18
			defb	0
			defb	18
			defb	35
			defb	42
			defb	46
			defb	42
			defb	35
	
			defb	18
			defb	0
			defb	-18
			defb	-35
			defb	-42
			defb	-46	;Wraparound
			ALIGN	256
buffer:
BUFFER_DEC		EQU	buffer+2049	;Music decompression
PT3_SETUP		EQU	BUFFER_DEC		;set bit0 to 1, if you want to play without looping
							;bit7 is set each time, when loop point is passed
PT3_MODADDR		EQU	BUFFER_DEC+1
PT3_CrPsPtr		EQU	BUFFER_DEC+3
PT3_SAMPTRS		EQU	BUFFER_DEC+5
PT3_OrnPtrs		EQU	BUFFER_DEC+7
PT3_PDSP		EQU	BUFFER_DEC+9
PT3_CSP			EQU	BUFFER_DEC+11
PT3_PSP			EQU	BUFFER_DEC+13
PT3_PrNote		EQU	BUFFER_DEC+15
PT3_PrSlide		EQU	BUFFER_DEC+16
PT3_AdInPtA		EQU	BUFFER_DEC+18
PT3_AdInPtB		EQU	BUFFER_DEC+20
PT3_AdInPtC		EQU	BUFFER_DEC+22
PT3_LPosPtr		EQU	BUFFER_DEC+24
PT3_PatsPtr		EQU	BUFFER_DEC+26
PT3_Delay		EQU	BUFFER_DEC+28
PT3_AddToEn		EQU	BUFFER_DEC+29
PT3_Env_Del		EQU	BUFFER_DEC+30
PT3_ESldAdd		EQU	BUFFER_DEC+31

VARS			EQU	BUFFER_DEC+33

ChanA			EQU	BUFFER_DEC+33			;CHNPRM_Size
ChanB			EQU	BUFFER_DEC+62			;CHNPRM_Size
ChanC			EQU	BUFFER_DEC+91			;CHNPRM_Size

;GlobalVars
DelyCnt			EQU	BUFFER_DEC+120
CurESld			EQU	BUFFER_DEC+121
CurEDel			EQU	BUFFER_DEC+123
Ns_Base_AddToNs		EQU	BUFFER_DEC+124
Ns_Base			EQU	BUFFER_DEC+124
AddToNs			EQU	BUFFER_DEC+125

AYREGS			EQU	BUFFER_DEC+126
VT_			EQU	BUFFER_DEC+126
EnvBase			EQU	BUFFER_DEC+140
VAR0END			EQU	BUFFER_DEC+142
DEC_PT3			EQU	VAR0END+240